var History = new Class({
  Implements: [Options, Events],
	options: {width: 1000, height: 410},
	owner: null,
  el: null,
	el_message_prototype: null,
	id_user: null,
	window: null,
	native_window: null,
	server: null,
  
	initialize: function(o, options, info){
		this.owner = o;
    this.setOptions(options);
		this.info = info;
		
		this.server = new Server({silent: true});
		
		var tpl = new Template("history_entry");    
		this.el_message_prototype = new Element('div').adopt(tpl.xml).getFirst();
		
		var t = this;
		var title = "CLIM - " + this.info.nick + " (história)";
		
		// create new window
		this.window = window.open("history.html", title, "height=" + this.options.height + ", width=" + this.options.width);
		this.native_window = this.window.nativeWindow;
		
		this.window.document.title = title;
		this.window.opener = this;
		
		// assign onClose event
		this.native_window.addEventListener(air.Event.CLOSE, function(){t.onClose();});
		this.native_window.addEventListener("resizing", function(event){
			event.preventDefault();
		});
  },
	
	//activate and show the new conversation window 
	open: function(){
	  this.native_window.activate(); 
	},
	
	close: function(){
		this.native_window.close();
	},
	
	save: function(){
		var docsDir = air.File.desktopDirectory;
		docsDir.browseForSave("Uložiť ako");
		var t = this;
		docsDir.addEventListener(air.Event.SELECT, function(event){
			t.saveHandler(event);
		});
	},
	
	saveHandler: function(event){
		var docsDir = air.File.desktopDirectory;
		docsDir.removeEventListener(air.Event.SELECT, this.saveHandler);
		
		// zistime nazov suboru ktory vybral pouzivatel
		var tmpArr = air.File(event.target).nativePath.split(air.File.separator);
		var fileName = tmpArr.pop();
		
		// zistime ci zadana pripona je .xml
		var fileExtension = fileName.split(".")[1];
		if(!$defined(fileExtension)){var fileExtension = '';}
		if(fileExtension.toLowerCase() != 'xml'){
			fileName = fileName.split(".")[0] + ".xml";
		}
		
		tmpArr.push(fileName);

		this.server.request({'action': 'get_history_xml', 'args': {'id_user_contact': this.info.id}}, function(response){
      if(!$defined(response)){
        alert('Chyba: nepodarilo sa získať históriu správ vo formáte XML.');
				
      } else if($defined(response) && $defined(response.xml)){
				var newFile = new air.File("file:///" + tmpArr.join(air.File.separator));
				
				//Make save
				var stream = new air.FileStream();
				stream.open(newFile, air.FileMode.WRITE);
				stream.writeUTFBytes(response.xml);
				stream.close();
      } 
    });
	},
	
	reload: function(){
		var t = this;
		
    this.server.request({'action': 'get_history', 'args': {'id_user_contact': this.info.id}}, function(response){
      if(!$defined(response)){
        alert('Chyba: nepodarilo sa získať históriu správ');
				
      } else if($defined(response) && $defined(response.messages)){
				// vyprazdnime zoznam
				var header = t.el.getElement('#messages_panel').getFirst().clone(true, true);
				t.el.getElement('#messages_panel').empty().adopt(header);
				
				response.messages.each(function(value, key){
					// zkopirujeme prototyp spravy
					var el = t.el_message_prototype.clone(true, true);			
					
					// naplnime spravu
					var time = new DateTime(value.time);
					el.getElement('.time').set('html', time.format());
					el.getElement('.text').set('html', value.text.replace(/\r?\n/g, '</br>'));
					
					if (value.type == 'sent') {
			  		el.getElement('.sender').set('html', t.owner.user.info.nick);
				  	el.getElement('.recipient').set('html', t.info.nick);
				  } else {
				  	el.getElement('.sender').set('html', t.info.nick);
			  		el.getElement('.recipient').set('html', t.owner.user.info.nick);
				  }
					
					t.el.getElement('#messages_panel').adopt(el);
				});
      }
    });
	},
	
	// raised when new conversation window was opened
	onLoad: function(){
		this.el = $(this.window.document.body.getElement('div#_main'));
		var t = this;
		this.el.getElement('#save_button').addEvent('click', function(){
			t.save();
		});
		this.reload();
	},
	
	onClose: function(){
		this.owner.user.closeContactHistory(this.info.id);
	}
});